/*
 * Decompiled with CFR 0.152.
 */
package com.momosoftworks.coldsweat.core.network.message;

import com.momosoftworks.coldsweat.util.ClientOnlyHelper;
import java.util.function.Supplier;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;
import net.minecraftforge.network.NetworkEvent;

public class SyncForgeDataMessage {
    CompoundTag forgeData;
    int entityID;
    String dimension;

    public SyncForgeDataMessage(Entity entity) {
        this.forgeData = entity.getPersistentData();
        this.entityID = entity.m_19879_();
        this.dimension = entity.f_19853_.m_46472_().m_135782_().toString();
    }

    public SyncForgeDataMessage(CompoundTag forgeData, int entityID, String dimension) {
        this.forgeData = forgeData;
        this.entityID = entityID;
        this.dimension = dimension;
    }

    public static void encode(SyncForgeDataMessage message, FriendlyByteBuf buffer) {
        buffer.m_130079_(message.forgeData);
        buffer.writeInt(message.entityID);
        buffer.m_130070_(message.dimension);
    }

    public static SyncForgeDataMessage decode(FriendlyByteBuf buffer) {
        return new SyncForgeDataMessage(buffer.m_130260_(), buffer.readInt(), buffer.m_130277_());
    }

    public static void handle(SyncForgeDataMessage message, Supplier<NetworkEvent.Context> contextSupplier) {
        NetworkEvent.Context context = contextSupplier.get();
        context.enqueueWork(() -> {
            Entity entity;
            Level level;
            if (context.getDirection().getReceptionSide().isClient() && ClientOnlyHelper.getClientLevel().m_46472_().m_135782_().toString().equals(message.dimension) && (level = ClientOnlyHelper.getClientLevel()) != null && (entity = level.m_6815_(message.entityID)) != null) {
                entity.getPersistentData().m_128391_(message.forgeData);
            }
        });
        context.setPacketHandled(true);
    }
}

